/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityItemCustom;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.item.ItemBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemHalloweenTreat
extends ItemBase {
    public ItemHalloweenTreat() {
        this.group = LycanitesMobs.group;
        this.itemName = "halloweentreat";
        this.setup();
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        if (!player.field_71075_bZ.field_75098_d) {
            --itemStack.field_77994_a;
        }
        if (!world.field_72995_K) {
            if (player.func_70681_au().nextBoolean()) {
                this.openGood(itemStack, world, player);
            } else {
                this.openBad(itemStack, world, player);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    public void openGood(ItemStack itemStack, World world, EntityPlayer player) {
        String message = I18n.func_74838_a((String)("item." + this.itemName + ".good"));
        player.func_145747_a((ITextComponent)new TextComponentString(message));
        if (AssetManager.getSound(this.itemName + "_good") == null) {
            AssetManager.addSound(this.itemName + "_good", this.group, "item." + this.itemName + ".good");
        }
        this.playSound(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, AssetManager.getSound(this.itemName + "_good"), SoundCategory.AMBIENT, 5.0f, 1.0f);
        for (int i = 0; i < 3; ++i) {
            ItemStack[] dropStacks = ObjectLists.getItems("halloween_treats");
            if (dropStacks == null || dropStacks.length <= 0) {
                return;
            }
            ItemStack dropStack = dropStacks[player.func_70681_au().nextInt(dropStacks.length)];
            if (dropStack == null || dropStack.func_77973_b() == null) continue;
            dropStack.field_77994_a = 1 + player.func_70681_au().nextInt(4);
            EntityItemCustom entityItem = new EntityItemCustom(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, dropStack);
            entityItem.func_174867_a(10);
            world.func_72838_d((Entity)entityItem);
        }
    }

    public void openBad(ItemStack itemStack, World world, EntityPlayer player) {
        String message = I18n.func_74838_a((String)("item." + this.itemName + ".bad"));
        player.func_145747_a((ITextComponent)new TextComponentString(message));
        if (AssetManager.getSound(this.itemName + "_bad") == null) {
            AssetManager.addSound(this.itemName + "_bad", this.group, "item." + this.itemName + ".bad");
        }
        this.playSound(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, AssetManager.getSound(this.itemName + "_bad"), SoundCategory.AMBIENT, 5.0f, 1.0f);
        Class[] entityClasses = ObjectLists.getEntites("halloween_tricks");
        if (entityClasses == null) {
            return;
        }
        if (entityClasses.length <= 0) {
            return;
        }
        Class entityClass = entityClasses[player.func_70681_au().nextInt(entityClasses.length)];
        if (entityClass != null) {
            Entity entity = null;
            try {
                entity = (Entity)entityClass.getConstructor(World.class).newInstance(world);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (entity != null) {
                entity.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
                if (entity instanceof EntityLivingBase) {
                    EntityCreatureBase entityCreature = (EntityCreatureBase)entity;
                    if (entityCreature.mobInfo.getEntityID().equals("grue")) {
                        entityCreature.func_96094_a("Shadow Clown");
                    }
                }
                world.func_72838_d(entity);
            }
        }
    }

    public static void createObjectLists() {
        ObjectLists.addItem("halloween_treats", Items.field_151045_i);
        ObjectLists.addItem("halloween_treats", Items.field_151043_k);
        ObjectLists.addItem("halloween_treats", Items.field_151166_bC);
        ObjectLists.addItem("halloween_treats", Blocks.field_150339_S);
        ObjectLists.addItem("halloween_treats", Items.field_151079_bi);
        ObjectLists.addItem("halloween_treats", Items.field_151072_bj);
        ObjectLists.addItem("halloween_treats", Items.field_151114_aO);
        ObjectLists.addItem("halloween_treats", ObjectManager.getItem("mosspie"));
        ObjectLists.addItem("halloween_treats", ObjectManager.getItem("bulwarkburger"));
        ObjectLists.addItem("halloween_treats", ObjectManager.getItem("paleosalad"));
        ObjectLists.addItem("halloween_treats", ObjectManager.getItem("searingtaco"));
        ObjectLists.addItem("halloween_treats", ObjectManager.getItem("devillasagna"));
        ObjectLists.addFromConfig("halloween_treats");
        ObjectLists.addEntity("halloween_tricks", "ghoulzombie");
        ObjectLists.addEntity("halloween_tricks", "cryptzombie");
        ObjectLists.addEntity("halloween_tricks", "belph");
        ObjectLists.addEntity("halloween_tricks", "behemoth");
        ObjectLists.addEntity("halloween_tricks", "ent");
        ObjectLists.addEntity("halloween_tricks", "trent");
        ObjectLists.addEntity("halloween_tricks", "nethersoul");
        ObjectLists.addEntity("halloween_tricks", "cacodemon");
        ObjectLists.addEntity("halloween_tricks", "grue");
        ObjectLists.addEntity("halloween_tricks", "phantom");
        ObjectLists.addEntity("halloween_tricks", "epion");
    }
}

